
*******************************************************************************************************
***     ANALYSIS:  Capturing Multiple Perspectives in a Multi-actor Survey: 						***
***				   The Impact of Parental Presence in Child Interviews on Reporting Discrepancies 	***					  										***
***		DATA:      Pairfam Waves 1 to 9, Release 9.1 						  			  			***
*** 	CONTENT:   - Data preparation: Merge child, parenting and anchor data				  		***
***				   - Outcome and explanatory variables									  			***
*******************************************************************************************************

clear all
set maxvar 15000
set more off
set varabbrev off

global path1 `""datapath""'  
global path2 `""outputpath""'  
global path3 `""syntaxpath""'  


** Data preparation: 
** Including information on interview experience and autonomy as a parenting goal in child in data sets child`wave'r.dta and anchor`wave'.dta
cd $path3	
do "0 Data Prep.do"


*** Merge anchor, parenting, and child information waves 6 to 9

cd $path1	

** Merge child data incl. number of effected interviews and and anchor reports on parenting waves 6-9
foreach wave in 6 7 8 9{
	use child`wave'r, clear					
	keep id cid pid wave csex cint* cpic* cpcr6* cpcr7* cpcr9i* cpcr10i* cinc25* csdq* cedu7* demodiff nbpart firstinthh cpcr7i1 cpcr7i8
	merge 1:1 cid using parenting`wave'r, keepusing (id cid pid wave sdq* pcr1* pcr2* pcr3* dropoffvers) 		
	
	keep if _merge==3					// keep if both (anchor) parenting interview and child interview
	drop _merge
	
	save apchild_`wave'.dta, replace
}

** Merge anchor data waves 6-9 
foreach wave in 6 7 8 9 {
	use anchor`wave'r, clear					
	keep id intid cid* pid wave hp capikidk* age sex_gen ehc10k* yeduc enrol pyeduc k*age k*sex_gen w*_crn19i* crn19i* crn11i* crn20* inc27i* ///
			inc28 migstatus nkidsliv nkids relstat lfs plfs sat1i4 sat6 demodiff intsex ccs2k* k*type capikid* job7 sdp12 cpas2 per4i5 per4i6 per4i7
			
	merge 1:m id using apchild_`wave', keepusing (id cid pid wave csex cint* cpic* cpcr6* cpcr7* cpcr9i* cpcr10i* cinc25* csdq* cedu7* sdq* ///
										pcr1* pcr2* pcr3* demodiff nbpart firstinthh cpcr7i1 cpcr7i8 dropoffvers) 
	keep if _merge==3
	drop _merge
	
	save apchild_`wave'.dta, replace
}


* Append datasets
use apchild_6, clear				
for num 7/9: append using apchild_X, nolabel	
sort id cid wave	
order id cid pid wave hp				
*br		
label lang en					
save apchild, replace	

for num 6/9: erase apchild_X.dta				// erase temporary data sets


*** Restrict analysis sample to cases where child interviews were conducted directly after the anchor interview

tab1 ccs2k*, m

gen n=cid-id-200	
gen intchild=.
forvalues x=1/10{
	bysort id: replace intchild=ccs2k`x' if n==`x'
}
tab intchild, m									// 41 cases -3
recode intchild (-3=.) (1=1) (2=0)					
tab intchild									// Section 3.1: 82.7% of all child interviews conducted after anchor interview
tab wave intchild, m

keep if intchild==1								
count											// N = 3,924
	

********************************
*** 	Outcome Measures	 ***
********************************

***  Child Reports

** Conduct problems 
tab1 	csdq1i5 csdq1i12 csdq1i18 csdq1i22 csdq1i7, m
recode 	csdq1i5 csdq1i12 csdq1i18 csdq1i22 csdq1i7 (-1 -2 -9=.)
recode  csdq1i7 (0=2) (1=1) (2=0), gen(csdq1i7_r)
egen help= rownonmiss(csdq1i5 csdq1i7_r csdq1i12 csdq1i18 csdq1i22)
egen conduct=rowmean(csdq1i5 csdq1i7_r csdq1i12 csdq1i18 csdq1i22) if inrange(help,3,5)
drop help
label var conduct "Child Perspective: Conduct Problems"
label def sdqscale 0 "0 low" 2 "2 high"
label val conduct sdqscale
tab conduct, m

** Hyperactivity symptoms
tab1 	csdq1i2 csdq1i10 csdq1i15 csdq1i21 csdq1i25, m
recode 	csdq1i2 csdq1i10 csdq1i15 csdq1i21 csdq1i25 (-1 -2 -9=.)
recode 	csdq1i21 (0=2) (1=1) (2=0), gen(csdq1i21_r)
recode 	csdq1i25 (0=2) (1=1) (2=0), gen(csdq1i25_r)
egen help=  rownonmiss(csdq1i2 csdq1i10 csdq1i15 csdq1i21_r csdq1i25_r)
egen hyper= rowmean(csdq1i2 csdq1i10 csdq1i15 csdq1i21_r csdq1i25_r) if inrange(help,3,5)
drop help
label var hyper "Child Perspective: Hyperactivity"
label val hyper sdqscale
tab hyper, m

** Emotional symptoms 
tab1 	csdq1i3 csdq1i8 csdq1i13 csdq1i16 csdq1i24, m
recode 	csdq1i3 csdq1i8 csdq1i13 csdq1i16 csdq1i24 (-1 -2 -9=.)
egen help= rownonmiss(csdq1i3 csdq1i8 csdq1i13 csdq1i16 csdq1i24)
egen emotion= rowmean(csdq1i3 csdq1i8 csdq1i13 csdq1i16 csdq1i24) if inrange(help,3,5)
drop help
label var emotion "Child Perspective: Emotional Problems"
label val emotion sdqscale
tab emotion, m

** Negative communication
tab1 	cpcr6i10 cpcr6i11 cpcr6i12, m
recode 	cpcr6i10 cpcr6i11 cpcr6i12 (-1 -2 -9=.)
egen help=rownonmiss(cpcr6i10 cpcr6i11 cpcr6i12)
egen negcomm=rowmean(cpcr6i10 cpcr6i11 cpcr6i12) if inlist(help,2,3)
drop help
label var negcomm "Child Perspective: Negative Communication" 
label val negcomm sdqscale5
tab negcomm, m

** Conflict 
tab1 cpcr7i4 cpcr7i6, m
recode cpcr7i4 cpcr7i6 (-1 -2 -9=.)
egen help=rownonmiss(cpcr7i4 cpcr7i6)
egen conflict=rowmean(cpcr7i4 cpcr7i6) if help==2
drop help
label var conflict "Child Perspective: Conflict"
label val conflict sdqscale5
tab conflict, m


*** Parent Reports

** Conduct Problems 
tab1 	sdqpi5 sdqpi12 sdqpi18 sdqpi22 sdqpi7,m 
recode 	sdqpi5 sdqpi12 sdqpi18 sdqpi22 sdqpi7 (-1 -2 -9=.)
recode  sdqpi7 (0=2) (1=1) (2=0), gen(sdqpi7_r)
egen help=rownonmiss(sdqpi5 sdqpi12 sdqpi18 sdqpi22 sdqpi7_r)
egen pconduct=rowmean(sdqpi5 sdqpi12 sdqpi18 sdqpi22 sdqpi7_r) if inrange(help,3,5)
drop help
label var pconduct "Parent Perspective: Conduct Problems"
label val pconduct sdqscale
tab pconduct, m

** Hyperactivity 
tab1 	sdqpi2 sdqpi10 sdqpi15 sdqpi21 sdqpi25, m
recode 	sdqpi2 sdqpi10 sdqpi15 sdqpi21 sdqpi25 (-1 -2 -9=.)
recode 	sdqpi21 (0=2) (1=1) (2=0), gen(sdqpi21_r)
recode 	sdqpi25 (0=2) (1=1) (2=0), gen(sdqpi25_r)
egen help=rownonmiss(sdqpi2 sdqpi10 sdqpi15 sdqpi21_r sdqpi25_r)
egen phyper= rowmean(sdqpi2 sdqpi10 sdqpi15 sdqpi21_r sdqpi25_r) if inrange(help,3,5)
drop help
label var phyper "Parent Perspective: Hyperactivity"
label val phyper sdqscale
tab phyper, m					// anchor reports on hyperactivity only in waves 7 and 9
tab wave phyper, m

** Emotional Symptoms 
tab1 	sdqpi3 sdqpi8 sdqpi13 sdqpi16 sdqpi24, m
recode 	sdqpi3 sdqpi8 sdqpi13 sdqpi16 sdqpi24 (-1 -2 -9=.)
egen help= rownonmiss(sdqpi3 sdqpi8 sdqpi13 sdqpi16 sdqpi24)
egen pemotion=rowmean(sdqpi3 sdqpi8 sdqpi13 sdqpi16 sdqpi24) if inrange(help,3,5)
drop help
label var pemotion "Parent Perspective: Emotional Problems"
label val pemotion sdqscale
tab pemotion, m

** Negative Communication
tab1 	pcr1i3 pcr1i8 pcr1i11, m
recode 	pcr1i3 pcr1i8 pcr1i11 (-1 -2 -9=.)
egen help= rownonmiss(pcr1i3 pcr1i8 pcr1i11)
egen pnegcomm=rowmean(pcr1i3 pcr1i8 pcr1i11) if inlist(help,2,3)
drop help
label var pnegcomm "Parent Perspective: Negative Communication" 
label val pnegcomm sdqscale5
tab pnegcomm, m

** Conflict
tab1 pcr3i4 pcr3i6, m
recode pcr3i4 pcr3i6 (-1 -2 -9=.)
egen help=rownonmiss(pcr3i4 pcr3i6)
egen pconflict=rowmean(pcr3i4 pcr3i6) if help==2
drop help
label var pconflict "Parent Perspective: Conflict"
label val pconflict sdqscale5
tab pconflict, m 



***	 Child-parent discrepancies

gen diffext=conduct-pconduct
gen diffhyper=hyper-phyper
gen diffint=emotion-pemotion
gen diffnegcomm=negcomm-pnegcomm
gen diffconflict=conflict-pconflict

label var diffext "Conduct problems"
label var diffhyper "Hyperactivity"
label var diffint "Emotional problems"
label var diffnegcomm "Negative communication"
label var diffconflict "Conflicts"

		
** Absolute values of discrepancies
foreach var of varlist diffext diffhyper diffint diffnegcomm diffconflict{
	gen a`var'=abs(`var')
}

label var adiffext "Conduct problems (abs.)"
label var adiffhyper "Hyperactivity (abs.)"
label var adiffint "Emotional problems (abs.)"
label var adiffnegcomm "Negative communication (abs.)"
label var adiffconflict "Conflicts (abs.)"


********************************
***	  Explanatory variables	 ***
********************************

** Parents present
gen pres=cint1i2
lab var pres "Parental Presence"
lab def pres 0 "Not present" 1 "Present"
lab val pres pres

tab pres, m
tab wave pres, row							
bysort demodiff: tab wave pres, row
tab pres demodiff, col chi2


** Child's age
cap drop n
gen n=cid-id-200	

gen kage=.
forvalues x=1/10{
	bysort id: replace kage=k`x'age if n==`x' & k`x'age!=-3
}

tab kage, m
gen kagen=kage
recode kagen (7=8) (16=15) 
lab def kagen 8 "8" 9 "9" 10 "10" 11 "11" 12 "12" 13 "13" 14 "14" 15 "15" 
lab val kagen kagen
tab kagen kage, m

gen agekat4=kage
recode agekat4 (7/9=1) (10/11=2) (12/13=3) (14/16=4) 
label def agekat4 1 "7-9" 2 "10-11" 3 "12-13" 4 "14-15"
label val agekat4 agekat4
tab agekat4 kage, m

gen agekat3=kage
recode agekat3 (7/10=1) (11/13=2) (14/16=3) 
label def agekat3 1 "7-10" 2 "11-13" 3 "14-16"
label val agekat3 agekat3
tab agekat3 kage, m

gen agekat2=kage
recode agekat2 (7/11=1) (12/max=0) 
label def agekat2 1 "7-11" 0 "12-15" 
label val agekat2 agekat2
tab agekat2, m
tab agekat2 kage, m

gen agekat2a=kage
recode agekat2a (7/10=1) (11/max=0) 
label def agekat2a 1 "7-10" 0 "11-15" 
label val agekat2a agekat2a
tab agekat2a, m
tab agekat2a kage, m

gen agekat2b=kage
recode agekat2b (7/12=1) (13/max=0) 
label def agekat2b 1 "7-12" 0 "13-15" 
label val agekat2b agekat2b
tab agekat2b, m
tab agekat2b kage, m

gen agekat2c=kage
recode agekat2c (7/13=1) (14/max=0) 
label def agekat2c 1 "7-13" 0 "14-15" 
label val agekat2c agekat2c
tab agekat2c, m
tab agekat2c kage, m


** Child's assertiveness (parent report)
tab1 	pcr3i3 pcr3i7, m
recode 	pcr3i3 pcr3i7 (-1 -2 -9=.)
egen help=rownonmiss(pcr3i3 pcr3i7)
egen assertive=rowmean(pcr3i3 pcr3i7) if help==2
drop help
label var assertive "Child's assertiveness (parent perspective)"
label val assertive sdqscale5
tab assertive, m


** Child’s interview experience: 1st interview
tab nbpart, m
tab wave nbpart, m

gen firstpart=nbpart
recode firstpart (1=1) (else=0)
tab firstpart, m
tab nbpart firstpart, m

label var firstpart "First child interview"
tab wave firstpart, m
bysort wave: tab firstpart pres, col chi2

*sort id cid wave
*br id cid wave nbpart


** First child interview in household
tab firstinthh, m			// variable generated in Do-File "0 Data Prep"
tab wave firstinthh, m 


** Monitoring (parent report)
tab1 	pcr1i2 pcr1i9 pcr1i6 pcr1i12, m
recode 	pcr1i2 pcr1i9 pcr1i6 pcr1i12 (-9 -2 -1=.) 
egen help=rownonmiss(pcr1i2 pcr1i9 pcr1i6 pcr1i12)
egen monitor=rowmean(pcr1i2 pcr1i9 pcr1i6 pcr1i12) if inlist(help,3,4)
drop help
label var monitor "Monitoring (parent perspective)"
label val monitor sdqscale5
tab monitor, m


** Autonomy as a child-rearing goal (parent report)

* crn19i* only in wave 2 and not for demodiff sample (included in anchor data sets in Do-File "0 Data Prep"); 
* in the following waves only for respondents who so far had no children in their household but have in the current wave biological/adoptive/step
* children in their household, or first-time respondents with biological/adoptive/step children in their household

tab1 w2_crn19i7 w2_crn19i8, m							
tab1 crn19i7 crn19i8, m
tab wave crn19i7, m
tab wave crn19i8, m

forvalues x=7/8{
gen tempcrn19i`x'=.
	replace tempcrn19i`x'=w2_crn19i`x' 
	replace tempcrn19i`x'=w3_crn19i`x' 	if tempcrn19i`x'==.
	replace tempcrn19i`x'=w4_crn19i`x' 	if tempcrn19i`x'==.
	replace tempcrn19i`x'=w5_crn19i`x' 	if tempcrn19i`x'==.
	replace tempcrn19i`x'=crn19i`x' 	if tempcrn19i`x'==.
	recode  tempcrn19i`x' (-3 -2 -1=.)
}

drop crn19i* w2_crn19i1*

forvalues x=7/8{
	ren tempcrn19i`x' crn19i`x'
	tab crn19i`x' demodiff, m
}

tab1 crn19i7 crn19i8,m
recode crn19i7 crn19i8 (-1 -2 -10=.)
egen help=rownonmiss(crn19i7 crn19i8)
egen auton=rowmean(crn19i7 crn19i8) if help==2
drop help 
lab var auton "Parenting goal: Autonomy"
lab def auton  0 "0 niedrig" 10 "10 hoch"
lab val auton auton
tab auton, m


** Intimacy in communication (parent report)
tab1 pcr3i1 pcr3i8, m
recode pcr3i1 pcr3i8 (-1 -2 -9=.)
egen help=rownonmiss(pcr3i1 pcr3i8)
egen intim=rowmean(pcr3i1 pcr3i8) if help==2
drop help
label var intim "Intimacy (parent perspective)"
label val intim sdqscale5
tab intim, m


* Low intimacy of communication (parent report, dummy variable)
tab1 pcr3i1 pcr3i8, m

** Categories "never", "seldom"
gen lintim=.
replace lintim=0 if (inlist(pcr3i1,3,4,5) | inlist(pcr3i8,3,4,5)) & (pcr3i1!=. & pcr3i8!=.)
replace lintim=1 if  inlist(pcr3i1,1,2)   & inlist(pcr3i8,1,2)

tab lintim, m
tab lintim pcr3i1,m
tab lintim pcr3i8,m

tab lintim, m

** Categories "never", "seldom", "sometimes"
gen lintim2=.
replace lintim2=0 if (inlist(pcr3i1,4,5)   | inlist(pcr3i8,4,5)) & (pcr3i1!=. & pcr3i8!=.)
replace lintim2=1 if  inlist(pcr3i1,1,2,3) & inlist(pcr3i8,1,2,3)

tab lintim2,m
tab pcr3i1 lintim2,m
tab pcr3i8 lintim2,m

lab var lintim2 "Low intimacy"
lab def lintim2 1 "1 yes" 0 "0 no"
lab val lintim2 lintim2

tab lintim2, m


for num 6/9: erase parentingXr.dta			// erase temporary data sets
for num 6/9: erase childXr.dta				// erase temporary data sets
for num 6/9: erase anchorXr.dta				// erase temporary data sets

cd $path1	
save parentpres.dta, replace


